<?php

namespace Chaka\TdbOutbandBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class TdbOutbandController extends Controller
{
    public function forwarderAction()
    {
        $security = $this->get('security.authorization_checker');
        if ($security->isGranted('ROLE_SUPER_ADMIN')) {
            return $this->redirect($this->generateUrl('parametres_index'));
        } else if ($security->isGranted('ROLE_SUPERVISEUR') || $security->isGranted('ROLE_CLIENT')) {
            return $this->redirect($this->generateUrl('chaka_realtime_homepage'));
        } else if ($security->isGranted('ROLE_TELEOPERATEUR')) {
            return $this->redirect($this->generateUrl('chaka_tdb_outband_homepage'));
        } else if ($security->isGranted('ROLE_STATISTIQUES')) {
            return $this->redirect($this->generateUrl('chaka_statistiques_homepage'));
        }
    }

    public function indexAction(Request $request)
    {
        $session = $this->get('session');
        //$session->set('nbAppelsTraites', 0);
        //$session->set('nbAppelsNonTraites', 0);

        $currentMachineIp = $this->container->get('request_stack')->getCurrentRequest()->getClientIp();
        /*if(!$this->isValidPublicIP($currentMachineIp)){ // check if the IP given by Sf Request is good. Otherwise, use the Native PHP REMOTE_ADDR
            $this->log(sprintf("Bad IP from SF: %s. Try the Remote ADDR\n", $ip));
            $currentMachineIp = $this->request->server->get('REMOTE_ADDR');
        }*/

        //TODO - A commenter après les tests A ENLEVER - JUSTE POUR LES TESTS EN LOCAL!!!!!!!
//        if ($currentMachineIp == "127.0.0.1"):
//            $currentMachineIp = "192.168.16.158";
         if ($currentMachineIp == "::1"):
            $currentMachineIp = "10.10.14.137";
        endif;

        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $userShift = $user->getShiftId();
        $userCampagnes = explode(";", substr($user->getCampagnes() , 0, -1) );

        if(sizeof($userCampagnes) < 1):
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Cet utilisateur n'est affecté à aucune campagne! 
                                      Merci de contacter le service informatique.");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        $dateConnexion = date('Y-m-d');
        $heureConnexion = date('H:i:s');

        $debutShift = 0;
        $finShift = 0;

        //Quand l'utilisateur se connecte pour la première fois au TDB
        if ($session->get('isFirstConnection') == null):
            $sqlPermutation = "SELECT CAST(shift_debut AS TIME) heure_debut,
                                CAST (shift_fin AS TIME) heure_fin, * FROM permutation
                                JOIN shift ON shift_id = permut_shift_id
                                WHERE permut_utilisateur_remplacant_id = $userId
                                AND permut_date_permutation = CURRENT_DATE
                                LIMIT 1";
            $stmtPermutation = $connexion->prepare($sqlPermutation);
            $stmtPermutation->execute();
            $permutation = $stmtPermutation->fetchAll();

            if (sizeof($permutation) == 0):
                $sql = "SELECT CAST(shift_debut AS TIME) heure_debut,
                        CAST (shift_fin AS TIME) heure_fin, * FROM shift
                        WHERE shift_id = $userShift
                        AND CURRENT_TIME
                        BETWEEN CAST(shift_debut AS TIME)
                        AND CAST (shift_fin AS TIME)
                        LIMIT 1";
                $stmt = $connexion->prepare($sql);
                $stmt->execute();
                $shift = $stmt->fetchAll();

                if (sizeof($shift) == 0):
                    $sqlHeureSup = "SELECT CAST(heure_sup_debut AS TIME) heure_debut,
                                    CAST (heure_sup_fin AS TIME) heure_fin, * FROM heure_sup
                                    WHERE heure_sup_utilisateur_id = $userId
                                    AND CURRENT_TIMESTAMP
                                    BETWEEN heure_sup_debut AND heure_sup_fin
                                    LIMIT 1";
                    $stmtHeureSup = $connexion->prepare($sqlHeureSup);
                    $stmtHeureSup->execute();
                    $heureSup = $stmtHeureSup->fetchAll();

                    if (sizeof($heureSup) == 0):
                        $request->getSession()
                            ->getFlashBag()
                            ->add('login_error', "Vous n'êtes pas autorié à vous connecter au tableau de bord! 
                                                  Merci de contacter le service informatique");;
                        return $this->redirect($this->generateUrl('fos_user_security_logout'));
                    else:
                        $debutShift = $heureSup[0]['heure_debut'];
                        $finShift = $heureSup[0]['heure_fin'];
                    endif;
                else:
                    $debutShift = $shift[0]['heure_debut'];
                    $finShift = $shift[0]['heure_fin'];
                endif;
            else:
                $debutShift = $permutation[0]['heure_debut'];
                $finShift = $permutation[0]['heure_fin'];
            endif;

            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    AND fp_date_fin_session IS NULL 
                    ORDER BY fp_date_pointage DESC 
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) == 0):
                $sqlInsert = "INSERT INTO feuille_presence
                              (fp_utilisateur_id,
                              fp_date_pointage,
                              fp_heure_pointage,
                              fp_temps_retard,
                              fp_nb_appels_traites,
                              fp_nb_appels_non_traites,
                              fp_ip_machine,
                              fp_utilisateur_matricule)
                              VALUES(
                              '$userId',
                              '$dateConnexion',
                              '$heureConnexion',
                              time '$heureConnexion' - time '$debutShift',
                              0,
                              0,
                              '$currentMachineIp',
                              '$userMatricule')";
                $stmt = $em->getConnection()->prepare($sqlInsert);
                $stmt->execute();
                $session->set('nbAppelsTraites', 0);
                $session->set('nbAppelsNonTraites', 0);
            else:
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;

            //Pour définir si l'utilisateur est déjà connecté
            //Ceci est pour éviter de faire des requêtes BD à chaque réactualisation du navigateur
            $session->set('isFirstConnection', 1);
        else:
            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) > 0):
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;
        endif;

        $sql = "SELECT * FROM positions WHERE positions_ip_machine = '$currentMachineIp' and actif=1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $position = $stmt->fetchAll();
        if (sizeof($position) > 0):
            $telephone = $position[0]['positions_num_poste'];
        else:
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Votre adresse IP $currentMachineIp n'est pas autorisé à se connecter au tableau de bord! 
                                      Merci de contacter le service informatique");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        //RECUPERATION DES TYPE DE PAUSE
        $sql = "SELECT * FROM type_pause ORDER BY type_pause_libelle";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $pausesAgent = $stmt->fetchAll();
        $jsonPausesAgent = json_encode($pausesAgent);
        //RECUPERATION DES CAMPAGNES DE L'AGENT
        $sql = "SELECT * FROM campagnes WHERE campagnes_id IN (".implode(',', $userCampagnes).") AND campagnes_appels_sortants_actif = 1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $userCampagnes = $stmt->fetchAll();
        //var_dump($userCampagnes);
        if (count($userCampagnes)<=0) {
           // echo "string";
            return $this->redirectToRoute('chaka_tdb_inband_homepage',array('return'=>'true'));
        }
        //RECUPERATION DE L'ADRESSE IP DU SERVEUR DANS LA TABLE PARAMETRES
        $sql = "SELECT parametres_cle, parametres_valeur FROM parametres WHERE parametres_cle LIKE 'SERVEUR_IP' OR parametres_cle LIKE 'SERVEUR_SOCKET_PORT' ";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $params = $stmt->fetchAll();
        if ($params[0]['parametres_cle'] == "SERVEUR_IP"):
            $serverIp = $params[0]['parametres_valeur'];
            $serverPort = $params[1]['parametres_valeur'];
        elseif ($params[0]['parametres_cle'] == "SERVEUR_SOCKET_PORT"):
            $serverIp = $params[1]['parametres_valeur'];
            $serverPort = $params[0]['parametres_valeur'];
        endif;

        return $this->render('ChakaTdbOutbandBundle:tdbOutband:index.html.twig',
            array(
                "serverIp" => $serverIp,
                "serverPort" => $serverPort,
                "currentMachineIp" => $currentMachineIp,
                "telephone" => $telephone,
                "jsonPausesAgent" => $jsonPausesAgent,
                "userCampagnes" => $userCampagnes,
            )
        );

    }
    public function indexnpsAction(Request $request)
    {
        $session = $this->get('session');
        //$session->set('nbAppelsTraites', 0);
        //$session->set('nbAppelsNonTraites', 0);

        $currentMachineIp = $this->container->get('request_stack')->getCurrentRequest()->getClientIp();
        /*if(!$this->isValidPublicIP($currentMachineIp)){ // check if the IP given by Sf Request is good. Otherwise, use the Native PHP REMOTE_ADDR
            $this->log(sprintf("Bad IP from SF: %s. Try the Remote ADDR\n", $ip));
            $currentMachineIp = $this->request->server->get('REMOTE_ADDR');
        }*/

        //TODO - A commenter après les tests A ENLEVER - JUSTE POUR LES TESTS EN LOCAL!!!!!!!
        if ($currentMachineIp == "127.0.0.1"):
            $currentMachineIp = "192.168.16.158";
        endif;

        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $userShift = $user->getShiftId();
        $userCampagnes = explode(";", substr($user->getCampagnes() , 0, -1) );

        if(sizeof($userCampagnes) < 1):
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Cet utilisateur n'est affecté à aucune campagne! 
                                      Merci de contacter le service informatique.");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        $dateConnexion = date('Y-m-d');
        $heureConnexion = date('H:i:s');

        $debutShift = 0;
        $finShift = 0;

        //Quand l'utilisateur se connecte pour la première fois au TDB
        if ($session->get('isFirstConnection') == null):
            $sqlPermutation = "SELECT CAST(shift_debut AS TIME) heure_debut,
                                CAST (shift_fin AS TIME) heure_fin, * FROM permutation
                                JOIN shift ON shift_id = permut_shift_id
                                WHERE permut_utilisateur_remplacant_id = $userId
                                AND permut_date_permutation = CURRENT_DATE
                                LIMIT 1";
            $stmtPermutation = $connexion->prepare($sqlPermutation);
            $stmtPermutation->execute();
            $permutation = $stmtPermutation->fetchAll();

            if (sizeof($permutation) == 0):
                $sql = "SELECT CAST(shift_debut AS TIME) heure_debut,
                        CAST (shift_fin AS TIME) heure_fin, * FROM shift
                        WHERE shift_id = $userShift
                        AND CURRENT_TIME
                        BETWEEN CAST(shift_debut AS TIME)
                        AND CAST (shift_fin AS TIME)
                        LIMIT 1";
                $stmt = $connexion->prepare($sql);
                $stmt->execute();
                $shift = $stmt->fetchAll();

                if (sizeof($shift) == 0):
                    $sqlHeureSup = "SELECT CAST(heure_sup_debut AS TIME) heure_debut,
                                    CAST (heure_sup_fin AS TIME) heure_fin, * FROM heure_sup
                                    WHERE heure_sup_utilisateur_id = $userId
                                    AND CURRENT_TIMESTAMP
                                    BETWEEN heure_sup_debut AND heure_sup_fin
                                    LIMIT 1";
                    $stmtHeureSup = $connexion->prepare($sqlHeureSup);
                    $stmtHeureSup->execute();
                    $heureSup = $stmtHeureSup->fetchAll();

                    if (sizeof($heureSup) == 0):
                        $request->getSession()
                            ->getFlashBag()
                            ->add('login_error', "Vous n'êtes pas autorié à vous connecter au tableau de bord! 
                                                  Merci de contacter le service informatique");;
                        return $this->redirect($this->generateUrl('fos_user_security_logout'));
                    else:
                        $debutShift = $heureSup[0]['heure_debut'];
                        $finShift = $heureSup[0]['heure_fin'];
                    endif;
                else:
                    $debutShift = $shift[0]['heure_debut'];
                    $finShift = $shift[0]['heure_fin'];
                endif;
            else:
                $debutShift = $permutation[0]['heure_debut'];
                $finShift = $permutation[0]['heure_fin'];
            endif;

            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    AND fp_date_fin_session IS NULL 
                    ORDER BY fp_date_pointage DESC 
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) == 0):
                $sqlInsert = "INSERT INTO feuille_presence
                              (fp_utilisateur_id,
                              fp_date_pointage,
                              fp_heure_pointage,
                              fp_temps_retard,
                              fp_nb_appels_traites,
                              fp_nb_appels_non_traites,
                              fp_ip_machine,
                              fp_utilisateur_matricule)
                              VALUES(
                              '$userId',
                              '$dateConnexion',
                              '$heureConnexion',
                              time '$heureConnexion' - time '$debutShift',
                              0,
                              0,
                              '$currentMachineIp',
                              '$userMatricule')";
                $stmt = $em->getConnection()->prepare($sqlInsert);
                $stmt->execute();
                $session->set('nbAppelsTraites', 0);
                $session->set('nbAppelsNonTraites', 0);
            else:
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;

            //Pour définir si l'utilisateur est déjà connecté
            //Ceci est pour éviter de faire des requêtes BD à chaque réactualisation du navigateur
            $session->set('isFirstConnection', 1);
        else:
            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) > 0):
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;
        endif;

        $sql = "SELECT * FROM positions WHERE positions_ip_machine = '$currentMachineIp' and actif=1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $position = $stmt->fetchAll();
        if (sizeof($position) > 0):
            $telephone = $position[0]['positions_num_poste'];
        else:
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Votre adresse IP $currentMachineIp n'est pas autorisé à se connecter au tableau de bord! 
                                      Merci de contacter le service informatique");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        //RECUPERATION DES TYPE DE PAUSE
        $sql = "SELECT * FROM type_pause ORDER BY type_pause_libelle";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $pausesAgent = $stmt->fetchAll();
        $jsonPausesAgent = json_encode($pausesAgent);
        //RECUPERATION DES CAMPAGNES DE L'AGENT
        $sql = "SELECT * FROM campagnes WHERE campagnes_id IN (".implode(',', $userCampagnes).") AND campagnes_appels_sortants_actif = 1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $userCampagnes = $stmt->fetchAll();
        //var_dump($userCampagnes);

        //RECUPERATION DE L'ADRESSE IP DU SERVEUR DANS LA TABLE PARAMETRES
        $sql = "SELECT parametres_cle, parametres_valeur FROM parametres WHERE parametres_cle LIKE 'SERVEUR_IP' OR parametres_cle LIKE 'SERVEUR_SOCKET_PORT' ";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $params = $stmt->fetchAll();
        if ($params[0]['parametres_cle'] == "SERVEUR_IP"):
            $serverIp = $params[0]['parametres_valeur'];
            $serverPort = $params[1]['parametres_valeur'];
        elseif ($params[0]['parametres_cle'] == "SERVEUR_SOCKET_PORT"):
            $serverIp = $params[1]['parametres_valeur'];
            $serverPort = $params[0]['parametres_valeur'];
        endif;

        return $this->render('ChakaTdbOutbandBundle:tdbOutbandNps:index.html.twig',
            array(
                "serverIp" => $serverIp,
                "serverPort" => $serverPort,
                "currentMachineIp" => $currentMachineIp,
                "telephone" => $telephone,
                "jsonPausesAgent" => $jsonPausesAgent,
                "userCampagnes" => $userCampagnes,
            )
        );

    }
  public function indexcorporateAction(Request $request)
    {
        $session = $this->get('session');
        //$session->set('nbAppelsTraites', 0);
        //$session->set('nbAppelsNonTraites', 0);

        $currentMachineIp = $this->container->get('request_stack')->getCurrentRequest()->getClientIp();
        /*if(!$this->isValidPublicIP($currentMachineIp)){ // check if the IP given by Sf Request is good. Otherwise, use the Native PHP REMOTE_ADDR
            $this->log(sprintf("Bad IP from SF: %s. Try the Remote ADDR\n", $ip));
            $currentMachineIp = $this->request->server->get('REMOTE_ADDR');
        }*/

        //TODO - A commenter après les tests A ENLEVER - JUSTE POUR LES TESTS EN LOCAL!!!!!!!
        if ($currentMachineIp == "127.0.0.1"):
            $currentMachineIp = "192.168.16.158";
        endif;

        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $userShift = $user->getShiftId();
        $userCampagnes = explode(";", substr($user->getCampagnes() , 0, -1) );

        if(sizeof($userCampagnes) < 1):
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Cet utilisateur n'est affecté à aucune campagne! 
                                      Merci de contacter le service informatique.");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        $dateConnexion = date('Y-m-d');
        $heureConnexion = date('H:i:s');

        $debutShift = 0;
        $finShift = 0;

        //Quand l'utilisateur se connecte pour la première fois au TDB
        if ($session->get('isFirstConnection') == null):
            $sqlPermutation = "SELECT CAST(shift_debut AS TIME) heure_debut,
                                CAST (shift_fin AS TIME) heure_fin, * FROM permutation
                                JOIN shift ON shift_id = permut_shift_id
                                WHERE permut_utilisateur_remplacant_id = $userId
                                AND permut_date_permutation = CURRENT_DATE
                                LIMIT 1";
            $stmtPermutation = $connexion->prepare($sqlPermutation);
            $stmtPermutation->execute();
            $permutation = $stmtPermutation->fetchAll();

            if (sizeof($permutation) == 0):
                $sql = "SELECT CAST(shift_debut AS TIME) heure_debut,
                        CAST (shift_fin AS TIME) heure_fin, * FROM shift
                        WHERE shift_id = $userShift
                        AND CURRENT_TIME
                        BETWEEN CAST(shift_debut AS TIME)
                        AND CAST (shift_fin AS TIME)
                        LIMIT 1";
                $stmt = $connexion->prepare($sql);
                $stmt->execute();
                $shift = $stmt->fetchAll();

                if (sizeof($shift) == 0):
                    $sqlHeureSup = "SELECT CAST(heure_sup_debut AS TIME) heure_debut,
                                    CAST (heure_sup_fin AS TIME) heure_fin, * FROM heure_sup
                                    WHERE heure_sup_utilisateur_id = $userId
                                    AND CURRENT_TIMESTAMP
                                    BETWEEN heure_sup_debut AND heure_sup_fin
                                    LIMIT 1";
                    $stmtHeureSup = $connexion->prepare($sqlHeureSup);
                    $stmtHeureSup->execute();
                    $heureSup = $stmtHeureSup->fetchAll();

                    if (sizeof($heureSup) == 0):
                        $request->getSession()
                            ->getFlashBag()
                            ->add('login_error', "Vous n'êtes pas autorié à vous connecter au tableau de bord! 
                                                  Merci de contacter le service informatique");;
                        return $this->redirect($this->generateUrl('fos_user_security_logout'));
                    else:
                        $debutShift = $heureSup[0]['heure_debut'];
                        $finShift = $heureSup[0]['heure_fin'];
                    endif;
                else:
                    $debutShift = $shift[0]['heure_debut'];
                    $finShift = $shift[0]['heure_fin'];
                endif;
            else:
                $debutShift = $permutation[0]['heure_debut'];
                $finShift = $permutation[0]['heure_fin'];
            endif;

            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    AND fp_date_fin_session IS NULL 
                    ORDER BY fp_date_pointage DESC 
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) == 0):
                $sqlInsert = "INSERT INTO feuille_presence
                              (fp_utilisateur_id,
                              fp_date_pointage,
                              fp_heure_pointage,
                              fp_temps_retard,
                              fp_nb_appels_traites,
                              fp_nb_appels_non_traites,
                              fp_ip_machine,
                              fp_utilisateur_matricule)
                              VALUES(
                              '$userId',
                              '$dateConnexion',
                              '$heureConnexion',
                              time '$heureConnexion' - time '$debutShift',
                              0,
                              0,
                              '$currentMachineIp',
                              '$userMatricule')";
                $stmt = $em->getConnection()->prepare($sqlInsert);
                $stmt->execute();
                $session->set('nbAppelsTraites', 0);
                $session->set('nbAppelsNonTraites', 0);
            else:
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;

            //Pour définir si l'utilisateur est déjà connecté
            //Ceci est pour éviter de faire des requêtes BD à chaque réactualisation du navigateur
            $session->set('isFirstConnection', 1);
        else:
            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) > 0):
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;
        endif;

        $sql = "SELECT * FROM positions WHERE positions_ip_machine = '$currentMachineIp' and actif=1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $position = $stmt->fetchAll();
        if (sizeof($position) > 0):
            $telephone = $position[0]['positions_num_poste'];
        else:
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Votre adresse IP $currentMachineIp n'est pas autorisé à se connecter au tableau de bord! 
                                      Merci de contacter le service informatique");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        //RECUPERATION DES TYPE DE PAUSE
        $sql = "SELECT * FROM type_pause ORDER BY type_pause_libelle";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $pausesAgent = $stmt->fetchAll();
        $jsonPausesAgent = json_encode($pausesAgent);
        //RECUPERATION DES CAMPAGNES DE L'AGENT
        $sql = "SELECT * FROM campagnes WHERE campagnes_id IN (".implode(',', $userCampagnes).") AND campagnes_appels_sortants_actif = 1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $userCampagnes = $stmt->fetchAll();
        //var_dump($userCampagnes);

        //RECUPERATION DE L'ADRESSE IP DU SERVEUR DANS LA TABLE PARAMETRES
        $sql = "SELECT parametres_cle, parametres_valeur FROM parametres WHERE parametres_cle LIKE 'SERVEUR_IP' OR parametres_cle LIKE 'SERVEUR_SOCKET_PORT' ";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $params = $stmt->fetchAll();
        if ($params[0]['parametres_cle'] == "SERVEUR_IP"):
            $serverIp = $params[0]['parametres_valeur'];
            $serverPort = $params[1]['parametres_valeur'];
        elseif ($params[0]['parametres_cle'] == "SERVEUR_SOCKET_PORT"):
            $serverIp = $params[1]['parametres_valeur'];
            $serverPort = $params[0]['parametres_valeur'];
        endif;

        return $this->render('ChakaTdbOutbandBundle:tdbOutbandCorporate:index.html.twig',
            array(
                "serverIp" => $serverIp,
                "serverPort" => $serverPort,
                "currentMachineIp" => $currentMachineIp,
                "telephone" => $telephone,
                "jsonPausesAgent" => $jsonPausesAgent,
                "userCampagnes" => $userCampagnes,
            )
        );

    }
    public function indexonboardingAction(Request $request)
    {
        
        $session = $this->get('session');
        //$session->set('nbAppelsTraites', 0);
        //$session->set('nbAppelsNonTraites', 0);

        $currentMachineIp = $this->container->get('request_stack')->getCurrentRequest()->getClientIp();
        /*if(!$this->isValidPublicIP($currentMachineIp)){ // check if the IP given by Sf Request is good. Otherwise, use the Native PHP REMOTE_ADDR
            $this->log(sprintf("Bad IP from SF: %s. Try the Remote ADDR\n", $ip));
            $currentMachineIp = $this->request->server->get('REMOTE_ADDR');
        }*/

        //TODO - A commenter après les tests A ENLEVER - JUSTE POUR LES TESTS EN LOCAL!!!!!!!
        if ($currentMachineIp == "127.0.0.1"):
            $currentMachineIp = "192.168.16.158";
        endif;

        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $userShift = $user->getShiftId();
        $userCampagnes = explode(";", substr($user->getCampagnes() , 0, -1) );

        if(sizeof($userCampagnes) < 1):
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Cet utilisateur n'est affecté à aucune campagne! 
                                      Merci de contacter le service informatique.");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        $dateConnexion = date('Y-m-d');
        $heureConnexion = date('H:i:s');

        $debutShift = 0;
        $finShift = 0;

        //Quand l'utilisateur se connecte pour la première fois au TDB
        if ($session->get('isFirstConnection') == null):
            $sqlPermutation = "SELECT CAST(shift_debut AS TIME) heure_debut,
                                CAST (shift_fin AS TIME) heure_fin, * FROM permutation
                                JOIN shift ON shift_id = permut_shift_id
                                WHERE permut_utilisateur_remplacant_id = $userId
                                AND permut_date_permutation = CURRENT_DATE
                                LIMIT 1";
            $stmtPermutation = $connexion->prepare($sqlPermutation);
            $stmtPermutation->execute();
            $permutation = $stmtPermutation->fetchAll();

            if (sizeof($permutation) == 0):
                $sql = "SELECT CAST(shift_debut AS TIME) heure_debut,
                        CAST (shift_fin AS TIME) heure_fin, * FROM shift
                        WHERE shift_id = $userShift
                        AND CURRENT_TIME
                        BETWEEN CAST(shift_debut AS TIME)
                        AND CAST (shift_fin AS TIME)
                        LIMIT 1";
                $stmt = $connexion->prepare($sql);
                $stmt->execute();
                $shift = $stmt->fetchAll();

                if (sizeof($shift) == 0):
                    $sqlHeureSup = "SELECT CAST(heure_sup_debut AS TIME) heure_debut,
                                    CAST (heure_sup_fin AS TIME) heure_fin, * FROM heure_sup
                                    WHERE heure_sup_utilisateur_id = $userId
                                    AND CURRENT_TIMESTAMP
                                    BETWEEN heure_sup_debut AND heure_sup_fin
                                    LIMIT 1";
                    $stmtHeureSup = $connexion->prepare($sqlHeureSup);
                    $stmtHeureSup->execute();
                    $heureSup = $stmtHeureSup->fetchAll();

                    if (sizeof($heureSup) == 0):
                        $request->getSession()
                            ->getFlashBag()
                            ->add('login_error', "Vous n'êtes pas autorié à vous connecter au tableau de bord! 
                                                  Merci de contacter le service informatique");;
                        return $this->redirect($this->generateUrl('fos_user_security_logout'));
                    else:
                        $debutShift = $heureSup[0]['heure_debut'];
                        $finShift = $heureSup[0]['heure_fin'];
                    endif;
                else:
                    $debutShift = $shift[0]['heure_debut'];
                    $finShift = $shift[0]['heure_fin'];
                endif;
            else:
                $debutShift = $permutation[0]['heure_debut'];
                $finShift = $permutation[0]['heure_fin'];
            endif;

            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    AND fp_date_fin_session IS NULL 
                    ORDER BY fp_date_pointage DESC 
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) == 0):
                $sqlInsert = "INSERT INTO feuille_presence
                              (fp_utilisateur_id,
                              fp_date_pointage,
                              fp_heure_pointage,
                              fp_temps_retard,
                              fp_nb_appels_traites,
                              fp_nb_appels_non_traites,
                              fp_ip_machine,
                              fp_utilisateur_matricule)
                              VALUES(
                              '$userId',
                              '$dateConnexion',
                              '$heureConnexion',
                              time '$heureConnexion' - time '$debutShift',
                              0,
                              0,
                              '$currentMachineIp',
                              '$userMatricule')";
                $stmt = $em->getConnection()->prepare($sqlInsert);
                $stmt->execute();
                $session->set('nbAppelsTraites', 0);
                $session->set('nbAppelsNonTraites', 0);
            else:
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;

            //Pour définir si l'utilisateur est déjà connecté
            //Ceci est pour éviter de faire des requêtes BD à chaque réactualisation du navigateur
            $session->set('isFirstConnection', 1);
        else:
            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) > 0):
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;
        endif;

        $sql = "SELECT * FROM positions WHERE positions_ip_machine = '$currentMachineIp' and actif=1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $position = $stmt->fetchAll();
        if (sizeof($position) > 0):
            $telephone = $position[0]['positions_num_poste'];
        else:
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Votre adresse IP $currentMachineIp n'est pas autorisé à se connecter au tableau de bord! 
                                      Merci de contacter le service informatique");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        //RECUPERATION DES TYPE DE PAUSE
        $sql = "SELECT * FROM type_pause ORDER BY type_pause_libelle";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $pausesAgent = $stmt->fetchAll();
        $jsonPausesAgent = json_encode($pausesAgent);
        //RECUPERATION DES CAMPAGNES DE L'AGENT
        $sql = "SELECT * FROM campagnes WHERE campagnes_id IN (".implode(',', $userCampagnes).") AND campagnes_appels_sortants_actif = 1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $userCampagnes = $stmt->fetchAll();
        //var_dump($userCampagnes);

        //RECUPERATION DE L'ADRESSE IP DU SERVEUR DANS LA TABLE PARAMETRES
        $sql = "SELECT parametres_cle, parametres_valeur FROM parametres WHERE parametres_cle LIKE 'SERVEUR_IP' OR parametres_cle LIKE 'SERVEUR_SOCKET_PORT' ";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $params = $stmt->fetchAll();
        if ($params[0]['parametres_cle'] == "SERVEUR_IP"):
            $serverIp = $params[0]['parametres_valeur'];
            $serverPort = $params[1]['parametres_valeur'];
        elseif ($params[0]['parametres_cle'] == "SERVEUR_SOCKET_PORT"):
            $serverIp = $params[1]['parametres_valeur'];
            $serverPort = $params[0]['parametres_valeur'];
        endif;

        return $this->render('ChakaTdbOutbandBundle:tdbOutbandOnboarding:index.html.twig',
            array(
                "serverIp" => $serverIp,
                "serverPort" => $serverPort,
                "currentMachineIp" => $currentMachineIp,
                "telephone" => $telephone,
                "jsonPausesAgent" => $jsonPausesAgent,
                "userCampagnes" => $userCampagnes,
            )
        );

    }  
public function indexreactivationAction(Request $request)
    {
        
        $session = $this->get('session');
        //$session->set('nbAppelsTraites', 0);
        //$session->set('nbAppelsNonTraites', 0);

        $currentMachineIp = $this->container->get('request_stack')->getCurrentRequest()->getClientIp();
        /*if(!$this->isValidPublicIP($currentMachineIp)){ // check if the IP given by Sf Request is good. Otherwise, use the Native PHP REMOTE_ADDR
            $this->log(sprintf("Bad IP from SF: %s. Try the Remote ADDR\n", $ip));
            $currentMachineIp = $this->request->server->get('REMOTE_ADDR');
        }*/

        //TODO - A commenter après les tests A ENLEVER - JUSTE POUR LES TESTS EN LOCAL!!!!!!!
        if ($currentMachineIp == "127.0.0.1"):
            $currentMachineIp = "192.168.16.158";
        endif;

        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $userShift = $user->getShiftId();
        $userCampagnes = explode(";", substr($user->getCampagnes() , 0, -1) );

        if(sizeof($userCampagnes) < 1):
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Cet utilisateur n'est affecté à aucune campagne! 
                                      Merci de contacter le service informatique.");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        $dateConnexion = date('Y-m-d');
        $heureConnexion = date('H:i:s');

        $debutShift = 0;
        $finShift = 0;

        //Quand l'utilisateur se connecte pour la première fois au TDB
        if ($session->get('isFirstConnection') == null):
            $sqlPermutation = "SELECT CAST(shift_debut AS TIME) heure_debut,
                                CAST (shift_fin AS TIME) heure_fin, * FROM permutation
                                JOIN shift ON shift_id = permut_shift_id
                                WHERE permut_utilisateur_remplacant_id = $userId
                                AND permut_date_permutation = CURRENT_DATE
                                LIMIT 1";
            $stmtPermutation = $connexion->prepare($sqlPermutation);
            $stmtPermutation->execute();
            $permutation = $stmtPermutation->fetchAll();

            if (sizeof($permutation) == 0):
                $sql = "SELECT CAST(shift_debut AS TIME) heure_debut,
                        CAST (shift_fin AS TIME) heure_fin, * FROM shift
                        WHERE shift_id = $userShift
                        AND CURRENT_TIME
                        BETWEEN CAST(shift_debut AS TIME)
                        AND CAST (shift_fin AS TIME)
                        LIMIT 1";
                $stmt = $connexion->prepare($sql);
                $stmt->execute();
                $shift = $stmt->fetchAll();

                if (sizeof($shift) == 0):
                    $sqlHeureSup = "SELECT CAST(heure_sup_debut AS TIME) heure_debut,
                                    CAST (heure_sup_fin AS TIME) heure_fin, * FROM heure_sup
                                    WHERE heure_sup_utilisateur_id = $userId
                                    AND CURRENT_TIMESTAMP
                                    BETWEEN heure_sup_debut AND heure_sup_fin
                                    LIMIT 1";
                    $stmtHeureSup = $connexion->prepare($sqlHeureSup);
                    $stmtHeureSup->execute();
                    $heureSup = $stmtHeureSup->fetchAll();

                    if (sizeof($heureSup) == 0):
                        $request->getSession()
                            ->getFlashBag()
                            ->add('login_error', "Vous n'êtes pas autorié à vous connecter au tableau de bord! 
                                                  Merci de contacter le service informatique");;
                        return $this->redirect($this->generateUrl('fos_user_security_logout'));
                    else:
                        $debutShift = $heureSup[0]['heure_debut'];
                        $finShift = $heureSup[0]['heure_fin'];
                    endif;
                else:
                    $debutShift = $shift[0]['heure_debut'];
                    $finShift = $shift[0]['heure_fin'];
                endif;
            else:
                $debutShift = $permutation[0]['heure_debut'];
                $finShift = $permutation[0]['heure_fin'];
            endif;

            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    AND fp_date_fin_session IS NULL 
                    ORDER BY fp_date_pointage DESC 
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) == 0):
                $sqlInsert = "INSERT INTO feuille_presence
                              (fp_utilisateur_id,
                              fp_date_pointage,
                              fp_heure_pointage,
                              fp_temps_retard,
                              fp_nb_appels_traites,
                              fp_nb_appels_non_traites,
                              fp_ip_machine,
                              fp_utilisateur_matricule)
                              VALUES(
                              '$userId',
                              '$dateConnexion',
                              '$heureConnexion',
                              time '$heureConnexion' - time '$debutShift',
                              0,
                              0,
                              '$currentMachineIp',
                              '$userMatricule')";
                $stmt = $em->getConnection()->prepare($sqlInsert);
                $stmt->execute();
                $session->set('nbAppelsTraites', 0);
                $session->set('nbAppelsNonTraites', 0);
            else:
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;

            //Pour définir si l'utilisateur est déjà connecté
            //Ceci est pour éviter de faire des requêtes BD à chaque réactualisation du navigateur
            $session->set('isFirstConnection', 1);
        else:
            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) > 0):
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;
        endif;

        $sql = "SELECT * FROM positions WHERE positions_ip_machine = '$currentMachineIp' and actif=1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $position = $stmt->fetchAll();
        if (sizeof($position) > 0):
            $telephone = $position[0]['positions_num_poste'];
        else:
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Votre adresse IP $currentMachineIp n'est pas autorisé à se connecter au tableau de bord! 
                                      Merci de contacter le service informatique");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        //RECUPERATION DES TYPE DE PAUSE
        $sql = "SELECT * FROM type_pause ORDER BY type_pause_libelle";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $pausesAgent = $stmt->fetchAll();
        $jsonPausesAgent = json_encode($pausesAgent);
        //RECUPERATION DES CAMPAGNES DE L'AGENT
        $sql = "SELECT * FROM campagnes WHERE campagnes_id IN (".implode(',', $userCampagnes).") AND campagnes_appels_sortants_actif = 1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $userCampagnes = $stmt->fetchAll();
        //var_dump($userCampagnes);

        //RECUPERATION DE L'ADRESSE IP DU SERVEUR DANS LA TABLE PARAMETRES
        $sql = "SELECT parametres_cle, parametres_valeur FROM parametres WHERE parametres_cle LIKE 'SERVEUR_IP' OR parametres_cle LIKE 'SERVEUR_SOCKET_PORT' ";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $params = $stmt->fetchAll();
        if ($params[0]['parametres_cle'] == "SERVEUR_IP"):
            $serverIp = $params[0]['parametres_valeur'];
            $serverPort = $params[1]['parametres_valeur'];
        elseif ($params[0]['parametres_cle'] == "SERVEUR_SOCKET_PORT"):
            $serverIp = $params[1]['parametres_valeur'];
            $serverPort = $params[0]['parametres_valeur'];
        endif;

        return $this->render('ChakaTdbOutbandBundle:tdbOutbandOnboarding:index.html.twig',
            array(
                "serverIp" => $serverIp,
                "serverPort" => $serverPort,
                "currentMachineIp" => $currentMachineIp,
                "telephone" => $telephone,
                "jsonPausesAgent" => $jsonPausesAgent,
                "userCampagnes" => $userCampagnes,
            )
        );

    }  

    public function loadFicheAction($nomCampagne)
    {
//        if (is_numeric($nomCampagne)) {
//            $em = $this->getDoctrine()->getManager();
//            $connexion = $em->getConnection();
//            $sql = "SELECT campagnes_nom FROM campagnes WHERE campagnes_dnis='$nomCampagne' LIMIT 1";
//            $stmt = $connexion->prepare($sql);
//            $stmt->execute();
//            $campagnes = $stmt->fetchAll();
//           // var_dump($nomCampagne,$sql);
//            $nomCampagne = $campagnes[0]['campagnes_nom'];
//           // var_dump($nomCampagne);
//        }
//        $response = $this->forward('ChakaTdbOutbandBundle:Fiche'.$nomCampagne.':index', array(
//        ));
         $response = $this->forward('ChakaTdbOutbandBundle:Fiche:index', array());
        return $response;
    }
    public function loadFicheNpsAction($nomCampagne)
    {
        if (is_numeric($nomCampagne)) {
            $em = $this->getDoctrine()->getManager();
            $connexion = $em->getConnection();
            $sql = "SELECT campagnes_nom FROM campagnes WHERE campagnes_dnis='$nomCampagne' LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $campagnes = $stmt->fetchAll();
            $nomCampagne = $campagnes[0]['campagnes_nom'];
        }
        $response = $this->forward('ChakaTdbOutbandBundle:FicheEcobankNps:index', array(
        ));
        return $response;
    }
      public function loadFicheCorporateAction($nomCampagne)
    { 
        if (is_numeric($nomCampagne)) {
            $em = $this->getDoctrine()->getManager();
            $connexion = $em->getConnection();
            $sql = "SELECT campagnes_nom FROM campagnes WHERE campagnes_dnis='$nomCampagne' LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $campagnes = $stmt->fetchAll();
            $nomCampagne = $campagnes[0]['campagnes_nom'];
        }
        $response = $this->forward('ChakaTdbOutbandBundle:FicheECOBANK_CORPORATE:index', array(
        ));
        return $response;
    }  
     public function loadFicheOnboardingAction($nomCampagne)
    { 
        if (is_numeric($nomCampagne)) {
            $em = $this->getDoctrine()->getManager();
            $connexion = $em->getConnection();
            $sql = "SELECT campagnes_nom FROM campagnes WHERE campagnes_dnis='$nomCampagne' LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $campagnes = $stmt->fetchAll();
            $nomCampagne = $campagnes[0]['campagnes_nom'];
        }
        $response = $this->forward('ChakaTdbOutbandBundle:FicheECOBANK_ONBOARDING:index', array(
        ));
        return $response;
    }  
    public function updateAcwAction($acw, $numPoste, $uuid)
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();
        $sql = "UPDATE appels SET appels_acw = '$acw' WHERE appels_uuid= '$uuid' AND appels_num_poste='$numPoste'";
        $stmt = $connexion->prepare($sql);
        $num_rows_affected = $stmt->execute();
        $response = new Response(
            json_encode(
                array(
                    'reponse' => "OK",
                    'numRows' => $num_rows_affected,
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    public function getAgentAction($matricule)
    {
        $em = $this->getDoctrine()->getManager();

        $sql = "SELECT prenom, nom FROM utilisateurs WHERE matricule = '$matricule' LIMIT 1";
        $stmt = $em->getConnection()->prepare($sql);
        $stmt->execute();
        $agent = $stmt->fetchAll();

        $prenom = $agent[0]['prenom'];
        $nom = $agent[0]['nom'];

        return new Response("$prenom $nom");
    }


    public function updateAgentNbreAppelsAction($matricule, $isAppelTraite)
    {
        $appelTraite = 0;
        $appelsNonTraite = 0;

        if ($isAppelTraite == 1):
            $appelTraite = 1;
        else:
            $appelsNonTraite = 1;
        endif;

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $userId = $user->getId();

        $sql = "UPDATE feuille_presence SET fp_nb_appels_traites = fp_nb_appels_traites + $appelTraite,
                fp_nb_appels_non_traites = fp_nb_appels_non_traites + $appelsNonTraite
                WHERE fp_utilisateur_id = $userId AND fp_date_pointage::date = CURRENT_DATE";
        $stmt = $em->getConnection()->prepare($sql);
        $stmt->execute();

        $session = $this->get('session');
        $session->set('nbAppelsTraites', $session->get('nbAppelsTraites') + $appelTraite);
        $session->set('nbAppelsNonTraites', $session->get('nbAppelsNonTraites') + $appelsNonTraite);

        $response = new Response(
            json_encode(
                array(
                    'nbAppelsTraites' => $session->get('nbAppelsTraites'),
                    'nbAppelsNonTraites' => $session->get('nbAppelsNonTraites'),
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');

        return $response;
    }

    public function savePauseAgentAction($pauseId, $numPoste)
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $userPrenom = str_replace("'", "''", $user->getPrenom()) ;
        $userNom = str_replace("'", "''", $user->getNom()) ;
        $datePause = date('Y-m-d H:i:s');

        $sql = "UPDATE agents set state='Idle' WHERE name='$numPoste'";
        $stmt = $connexion->prepare($sql);
        $num_rows_affected = $stmt->execute();

        $sql = "INSERT INTO pause_agent (
                pa_type_pause_id,
                pa_utilisateur_id,
                pa_utilisateur_matricule,
                pa_utilisateur_prenom,
                pa_utilisateur_nom,
                pa_date_debut)
                VALUES(
                $pauseId,
                $userId,
                '$userMatricule',
                '$userPrenom',
                '$userNom',
                '$datePause'
                )";
        $stmt = $connexion->prepare($sql);
        $num_rows_affected = $stmt->execute();

        if ($num_rows_affected < 1):
            $retour = "KO";
        else:
            $retour = "OK";
        endif;

        $response = new Response(
            json_encode(
                array(
                    'reponse' => $retour,
                    'num_rows_affected' => $num_rows_affected,
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    public function saveReprisePauseAgentAction()
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $datePause = date('Y-m-d H:i:s');

        $sql = "UPDATE pause_agent
                SET pa_date_fin = '$datePause'
                WHERE pa_utilisateur_id = $userId
                AND pa_date_fin is null
                ";
        $stmt = $connexion->prepare($sql);
        $num_rows_affected = $stmt->execute();

        if ($num_rows_affected < 1):
            $retour = "KO";
        else:
            $retour = "OK";
        endif;

        $response = new Response(
            json_encode(
                array(
                    'reponse' => $retour,
                    'num_rows_affected' => $num_rows_affected,
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    public function updateStateAgentTransfertAction($matricule, $numPoste)
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();
        $sql = "UPDATE agents SET state= 'Idle' WHERE name= '$numPoste' AND state='Waiting'";
        $stmt = $connexion->prepare($sql);
        $num_rows_affected = $stmt->execute();
        if($num_rows_affected < 1):
            $retour = "KO";
        else:
            $retour = "OK";
        endif;

        $response = new Response(
            json_encode(
                array(
                    'reponse' => $retour,
                    'query'=> $sql,
                    'num_rows_affected' => $num_rows_affected,
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }
}
