<?php

namespace Chaka\TdbInbandBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
class TdbInbandController extends Controller
{
    public function indexAction(Request $request)
    {
        /*echo "<pre>";
        var_dump($request);
        echo "</pre>";*/
        $session = $this->get('session');
        //$session->set('nbAppelsTraites', 0);
        //$session->set('nbAppelsNonTraites', 0);

        $currentMachineIp = $this->container->get('request_stack')->getCurrentRequest()->getClientIp();
        /*if(!$this->isValidPublicIP($currentMachineIp)){ // check if the IP given by Sf Request is good. Otherwise, use the Native PHP REMOTE_ADDR
            $this->log(sprintf("Bad IP from SF: %s. Try the Remote ADDR\n", $ip));
            $currentMachineIp = $this->request->server->get('REMOTE_ADDR');
        }*/

        //TODO - A commenter après les tests A ENLEVER - JUSTE POUR LES TESTS EN LOCAL!!!!!!!
        if ($currentMachineIp == "::1"):
            $currentMachineIp = "10.10.14.137";
        endif;

        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $userShift = $user->getShiftId();
        $userCampagnes = explode(";", substr($user->getCampagnes() , 0, -1) );

        if(sizeof($userCampagnes) < 1):
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Cet utilisateur n'est affecté à aucune campagne! 
                                      Merci de contacter le service informatique.");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        $dateConnexion = date('Y-m-d');
        $heureConnexion = date('H:i:s');

        $debutShift = 0;
        $finShift = 0;

        //Quand l'utilisateur se connecte pour la première fois au TDB
        if ($session->get('isFirstConnection') == null):
            $sqlPermutation = "SELECT CAST(shift_debut AS TIME) heure_debut,
                                CAST (shift_fin AS TIME) heure_fin, * FROM permutation
                                JOIN shift ON shift_id = permut_shift_id
                                WHERE permut_utilisateur_remplacant_id = $userId
                                AND permut_date_permutation = CURRENT_DATE
                                LIMIT 1";
            $stmtPermutation = $connexion->prepare($sqlPermutation);
            $stmtPermutation->execute();
            $permutation = $stmtPermutation->fetchAll();

            if (sizeof($permutation) == 0):
                $sql = "SELECT CAST(shift_debut AS TIME) heure_debut,
                        CAST (shift_fin AS TIME) heure_fin, * FROM shift
                        WHERE shift_id = $userShift
                        AND CURRENT_TIME
                        BETWEEN CAST(shift_debut AS TIME)
                        AND CAST (shift_fin AS TIME)
                        LIMIT 1";
                $stmt = $connexion->prepare($sql);
                $stmt->execute();
                $shift = $stmt->fetchAll();

                if (sizeof($shift) == 0):
                    $sqlHeureSup = "SELECT CAST(heure_sup_debut AS TIME) heure_debut,
                                    CAST (heure_sup_fin AS TIME) heure_fin, * FROM heure_sup
                                    WHERE heure_sup_utilisateur_id = $userId
                                    AND CURRENT_TIMESTAMP
                                    BETWEEN heure_sup_debut AND heure_sup_fin
                                    LIMIT 1";
                    $stmtHeureSup = $connexion->prepare($sqlHeureSup);
                    $stmtHeureSup->execute();
                    $heureSup = $stmtHeureSup->fetchAll();

                    if (sizeof($heureSup) == 0):
                        $request->getSession()
                            ->getFlashBag()
                            ->add('login_error', "Vous n'êtes pas autorié à vous connecter au tableau de bord! 
                                                  Merci de contacter le service informatique");;
                        return $this->redirect($this->generateUrl('fos_user_security_logout'));
                    else:
                        $debutShift = $heureSup[0]['heure_debut'];
                        $finShift = $heureSup[0]['heure_fin'];
                    endif;
                else:
                    $debutShift = $shift[0]['heure_debut'];
                    $finShift = $shift[0]['heure_fin'];
                endif;
            else:
                $debutShift = $permutation[0]['heure_debut'];
                $finShift = $permutation[0]['heure_fin'];
            endif;

            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    AND fp_date_fin_session IS NULL 
                    ORDER BY fp_date_pointage DESC 
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) == 0):
                $sqlInsert = "INSERT INTO feuille_presence
                              (fp_utilisateur_id,
                              fp_date_pointage,
                              fp_heure_pointage,
                              fp_temps_retard,
                              fp_nb_appels_traites,
                              fp_nb_appels_non_traites,
                              fp_ip_machine,
                              fp_utilisateur_matricule)
                              VALUES(
                              '$userId',
                              '$dateConnexion',
                              '$heureConnexion',
                              time '$heureConnexion' - time '$debutShift',
                              0,
                              0,
                              '$currentMachineIp',
                              '$userMatricule')";
                $stmt = $em->getConnection()->prepare($sqlInsert);
                $stmt->execute();
                $session->set('nbAppelsTraites', 0);
                $session->set('nbAppelsNonTraites', 0);
            else:
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;

            //Pour définir si l'utilisateur est déjà connecté
            //Ceci est pour éviter de faire des requêtes BD à chaque réactualisation du navigateur
            $session->set('isFirstConnection', 1);
        else:
            $sql = "SELECT * FROM feuille_presence
                    WHERE fp_utilisateur_id = $userId
                    AND fp_date_pointage::date = CURRENT_DATE
                    LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $feuillePresence = $stmt->fetchAll();

            if (sizeof($feuillePresence) > 0):
                $session->set('nbAppelsTraites', $feuillePresence[0]['fp_nb_appels_traites']);
                $session->set('nbAppelsNonTraites', $feuillePresence[0]['fp_nb_appels_non_traites']);
            endif;
        endif;

        $sql = "SELECT * FROM positions WHERE positions_ip_machine = '$currentMachineIp' and actif=1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $position = $stmt->fetchAll();
        if (sizeof($position) > 0):
            $telephone = $position[0]['positions_num_poste'];
        else:
            $request->getSession()
                ->getFlashBag()
                ->add('login_error', "Votre adresse IP $currentMachineIp n'est pas autorisé à se connecter au tableau de bord! 
                                      Merci de contacter le service informatique");
            return $this->redirect($this->generateUrl('fos_user_security_logout'));
        endif;

        //RECUPERATION DES TYPE DE PAUSE
        $sql = "SELECT * FROM type_pause ORDER BY type_pause_libelle";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $pausesAgent = $stmt->fetchAll();
        $jsonPausesAgent = json_encode($pausesAgent);
        //RECUPERATION DES CAMPAGNES DE L'AGENT
        $sql = "SELECT * FROM campagnes WHERE campagnes_id IN (".implode(',', $userCampagnes).") AND campagnes_appels_entrants_actif = 1";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $userCampagnes = $stmt->fetchAll();

        if (count($userCampagnes)<=0) {
           // echo "string";
            return $this->redirectToRoute('chaka_tdb_outband_homepage',array('return'=>'true'));
        }
        //var_dump($userCampagnes);exit;

        //RECUPERATION DE L'ADRESSE IP DU SERVEUR DANS LA TABLE PARAMETRES
        $sql = "SELECT parametres_cle, parametres_valeur FROM parametres WHERE parametres_cle LIKE 'SERVEUR_IP' OR parametres_cle LIKE 'SERVEUR_SOCKET_PORT' ";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $params = $stmt->fetchAll();
        if ($params[0]['parametres_cle'] == "SERVEUR_IP"):
            $serverIp = $params[0]['parametres_valeur'];
            $serverPort = $params[1]['parametres_valeur'];
        elseif ($params[0]['parametres_cle'] == "SERVEUR_SOCKET_PORT"):
            $serverIp = $params[1]['parametres_valeur'];
            $serverPort = $params[0]['parametres_valeur'];
        endif;
      //Informations sur la page facebook
        $sqlF = "SELECT * from facebook_infos limit 1";
        $stmtF = $connexion->prepare($sqlF);
        $stmtF->execute();
        $infosFacebook = $stmtF->fetchAll();
        $token=$infosFacebook[0]['token'];
        $idApp=$infosFacebook[0]['id_app'];
        $idPage=$infosFacebook[0]['id_page'];
                
                
        return $this->render('ChakaTdbInbandBundle:tdbInband:index.html.twig',
            array(
                "serverIp" => $serverIp,
                "serverPort" => $serverPort,
                "currentMachineIp" => $currentMachineIp,
                "telephone" => $telephone,
                "jsonPausesAgent" => $jsonPausesAgent,
                "userCampagnes" => $userCampagnes,
                "token" => $token,
                "idApp" => $idApp,
                "idPage" => $idPage,
            )
        );
    }

    public function loadFicheAction($nomCampagne)
    {
        if (is_numeric($nomCampagne)) {
            $em = $this->getDoctrine()->getManager();
            $connexion = $em->getConnection();
            $sql = "SELECT campagnes_nom FROM campagnes WHERE campagnes_dnis='$nomCampagne' LIMIT 1";
            $stmt = $connexion->prepare($sql);
            $stmt->execute();
            $campagnes = $stmt->fetchAll();
            $nomCampagne = $campagnes[0]['campagnes_nom'];
        }
       
        $response = $this->forward('ChakaTdbInbandBundle:Fiche:index', array());
//         $response = $this->forward('ChakaTdbInbandBundle:Fiche'.$nomCampagne.':index', array());
        return $response;
    }
        public function importAction(Request $request)
    {
        $statInsert='0'; 
        $em = $this->getDoctrine()->getManager();
        $connexion  = $em->getConnection();


        // $resultat = $this->testerFichierCSV($request);

        // if($resultat =="KO"){
        //   $request->getSession()->getFlashBag()->set('danger', 'Importation a échoué!');
        //      //return new JsonResponse(array('return'=>'false'));
        //      return $this->redirectToRoute('groupecontact_index',array('return'=>'false'));
        // }
         
        $file      = $request->files->get('fileCSV');
        $type      = $request->request->get('type');
        $matricule = $request->request->get('matricule');
        $filePath  = $file->getRealPath();
        $sql = '';
        //var_dump($type);exit;
        if ($type=='NPS') {
             $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;$num_rows_affected='';
               $total=0;
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                    
                    //var_dump($array);
                    if ($firstLigne==true)
                        {
                         $title=$array;
                         $firstLigne=false;
                        }else{
                        //  var_dump('<br><br><br> $title', $title,'<br><br><br><br>');
                                 $correctBranchName='';
                                 $TRANSACTION_DATE=$PRODUCT_DESCRIPTION=$PHONE_NO=$EMAIL=$AC_NAME=$AC_NO=$BANK_CODE='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                   
                               if (isset($title[$i]) && $title[$i]=="BRANCH_NAME") {

                                   $banchName=explode(" ",$array[$i]);
                                    //var_dump($banchName);
                                   if (isset($banchName[2]) && $banchName[2]=='PRINCIPALE') {
                                       $correctBranchName='ESN AGENCE PRINCIPALE';
                                   } elseif (isset($banchName[2])) {
                                       $correctBranchName='ESN '.$banchName[2];
                                   } elseif (isset($banchName[3])) {
                                       $correctBranchName='ESN '.$banchName[2].' '.$banchName[3];
                                   }elseif (isset($banchName[4])) {
                                       $correctBranchName='ESN '.$banchName[2].' '.$banchName[3].' '.$banchName[4];
                                   }else{
                                       $correctBranchName='ESN '.$banchName[1];
                                   }
                               }
                                 if (isset($title[$i]) && $title[$i]=="BANK_CODE") 
                                     $BANK_CODE=$array[$i];
                                 if (isset($title[$i]) && $title[$i]=="AC_NO") 
                                     $AC_NO=$array[$i];
                                 if (isset($title[$i]) && $title[$i]=="AC_NAME") 
                                     $AC_NAME=$array[$i];
                                 if (isset($title[$i]) && $title[$i]=="EMAIL") 
                                     $EMAIL=$array[$i];
                                 if (isset($title[$i]) && $title[$i]=="PHONE_NO") 
                                     $PHONE_NO=$array[$i];
                                 if (isset($title[$i]) && $title[$i]=="PRODUCT_DESCRIPTION") 
                                     $PRODUCT_DESCRIPTION=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="TRANSACTION_DATE") 
                                     $TRANSACTION_DATE=$array[$i]; 
                                      //var_dump('IN@@@TRANSACTION_DATE:'.$array[$i]);}
                                 
                                     //var_dump('<br> --',$title[$i].'****'.$array[$i],'--<br>',$i,$array);
                            } 
                            $sql="INSERT INTO public.client_infos_nps(id_client,phone_no, bank_code, branch_name, ac_no, ac_name, email,product_description,transaction_date)VALUES(DEFAULT,'".$PHONE_NO."','".$BANK_CODE."', '".$correctBranchName."','".$AC_NO."','".$AC_NAME."', '".$EMAIL."','".$PRODUCT_DESCRIPTION."','".$TRANSACTION_DATE."')";       

                            //var_dump($sql);exit;
                          $trouve=true;
                          if($correctBranchName==''&& $TRANSACTION_DATE==''&& $PRODUCT_DESCRIPTION==''&& $PHONE_NO==''&& $EMAIL==''&& $AC_NAME==''&& $AC_NO==''&& $BANK_CODE=='')
                             $trouve=false;
                          if($trouve)
                          {
                           $total++;      
                           $stmt = $connexion->prepare($sql);
                           $stmt->execute();
                           $num_rows_affected1 = $connexion->lastInsertId();
                           $num_rows_affected=$num_rows_affected.';'.$num_rows_affected1;
                          }
                     }
                   
                }
                $sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'NPS','".$matricule."','".$total."')";
                $stmt=$connexion->prepare($sql);
                $stmt->execute(); 
             fclose($f);
        }
        if ($type=='ONBOARDING') {
              $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;
               $num_rows_affected='';
               $total=0;
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                    
                    //var_dump($total);
                    if ($firstLigne==true)
                        {
                         $title=$array;
                         $firstLigne=false;
                        }else{
                                $BRANCH_CODE=$BRANCH_NAME=$ACCOUNT_NO=$ACCOUNT_NAME=$DESCRIPTION=$DATE_OPENED=$TELEPHONE=$EMAIL='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                   
                                 if (isset($title[$i]) && (trim($title[$i])=="ACCOUNT NO" || trim($title[$i])=="ACCOUNT_NO")) 
                                     $ACCOUNT_NO=$array[$i];
                                 if (isset($title[$i]) && (trim($title[$i])=="ACCOUNT NAME" || trim($title[$i])=="ACCOUNT_NAME")) 
                                     $ACCOUNT_NAME=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="DESCRIPTION") 
                                     $DESCRIPTION=$array[$i];
                                 if (isset($title[$i]) && (trim($title[$i])=="DATE OPENED" || trim($title[$i])=="DATE_OPENED")) 
                                     $DATE_OPENED=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="TELEPHONE") 
                                     $TELEPHONE=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="EMAIL") 
                                     $EMAIL=$array[$i];
                                 if (isset($title[$i]) && (trim($title[$i])=="BRANCH NAME" || trim($title[$i])=="BRANCH NAME")) 
                                     $BRANCH_NAME=$array[$i];  
                                 if (isset($title[$i]) && (trim($title[$i])=="BRANCH CODE" || trim($title[$i])=="BRANCH CODE")) 
                                     $BRANCH_CODE=$array[$i];  

                                

                                 
                                 
                            }
                            $sql="INSERT INTO public.client_infos_onboarding(id_client,telephone,branche_code,account_no, account_name, email,type_compte,branche_name,date_opened) VALUES(DEFAULT,'".$TELEPHONE."','".$BRANCH_CODE."','".$ACCOUNT_NO."','".$ACCOUNT_NAME."', '".$EMAIL."','".$DESCRIPTION."','".$BRANCH_NAME."','".$DATE_OPENED."')";       
                        
                             $PHONE=$this->cleanPhone($TELEPHONE);
                             $sql_numerol="INSERT INTO public.numero(id,libelle,status,nom_campagne,dnis_campagne,id_campagne)VALUES(DEFAULT,'".$PHONE."','".$statInsert."','ECOBANK_ONBOARDING','2600','5')"; 
                             if (trim($PHONE)!='') { 
                              $stmt = $connexion->prepare($sql_numerol);
                              $stmt->execute();
                             }
                      $trouve=true;
                     if($ACCOUNT_NO=='' && $ACCOUNT_NAME=='' && $DESCRIPTION=='' && $DATE_OPENED=='' && $TELEPHONE=='' && $EMAIL=='')
                      $trouve=false;       
                     if($trouve)
                     {  
                      $total++;     
                      $stmt = $connexion->prepare($sql);
                      $stmt->execute();
                      $num_rows_affected1 = $connexion->lastInsertId();
                      $num_rows_affected=$num_rows_affected.';'.$num_rows_affected1;
                     }
                        }
                   
                }
                $sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'ONBOARDING','".$matricule."','".$total."')";
                $stmt=$connexion->prepare($sql);
                $stmt->execute();       
             fclose($f);
             //exit();
        }
        if ($type=='CORPORATE') {
            $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;
               $num_rows_affected='';$total=0;
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                    //var_dump($array);
                    
                    if ($firstLigne==true)
                        {
                         $title=$array;
                         $firstLigne=false;
                        }else{
                                 $Nomentreprise=$Pays=$Segment=$Contact=$AdresseEmail=$TEL='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                  //var_dump(trim($title[$i]) ,'<br>'); 
                                 if (isset($title[$i]) && trim($title[$i])=="Nom de L’entreprise") 
                                     $Nomentreprise=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Pays") 
                                     $Pays=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Segment") 
                                     $Segment=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Contact") 
                                     $Contact=$array[$i];
                                 if (isset($title[$i]) && (trim($title[$i])=="Adresse Email" || trim($title[$i])==" Adresse Email "|| trim($title[$i])==" Adresse Email") ) 
                                     $AdresseEmail=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="TEL") 
                                     $TEL=$array[$i];
                                
                                 
                                 
                            }
                            $sql="INSERT INTO public.client_infos_corporate(id_client,contact1, tel1, societe, mail,pays) VALUES(DEFAULT,'".$Contact."','".$TEL."','".$Nomentreprise."', '".$AdresseEmail."','".$Pays."')";       
                            $PHONE=$this->cleanPhone($TEL);
                            //var_dump( $sql);
                             $sql_numerol="INSERT INTO public.numero(id,libelle,status,nom_campagne,dnis_campagne,id_campagne)VALUES(DEFAULT,'".$PHONE."','".$statInsert."','ECOBANK_CORPORATE','2500','3')"; 
                             $stmt = $connexion->prepare($sql_numerol);
                             $stmt->execute();
                            $trouve=true;
                            if($Nomentreprise=='' && $Pays=='' && $Segment=='' && $Contact=='' && $AdresseEmail=='' && $TEL)
                            $trouve=false;
                            if($trouve)
                            { 
                             $total++;  
                             $stmt = $connexion->prepare($sql);
                             $stmt->execute();
                             $num_rows_affected1 = $connexion->lastInsertId();
                             $num_rows_affected=$num_rows_affected.';'.$num_rows_affected1;
                            }
                        }
                   
                }
                $sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'CORPORATE','".$matricule."','".$total."')";
                $stmt=$connexion->prepare($sql);
                $stmt->execute();       
             fclose($f);
             //return false;
        }
        if ($type=='REACTIVATION') {
            $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;
               $num_rows_affected='';$total=0;
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                   
                //  var_dump($sql);
                    if ($firstLigne==true)
                        { 
                         $title=$array;
                         $firstLigne=false;
                         //var_dump('<br>*****<br>',$array,'<br>*****<br>');
                        }else{
                                 $numero_compte=$prenom_et_nom=$priorites=$solde=$telephone=$signataire_sur_le_compte='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                     //var_dump('<br>*****<br>',$array,'<br>');
                                 if (isset($title[$i]) && trim($title[$i])=="NUMERO COMPTE ") 
                                     $numero_compte=$array[$i];
                                 if (isset($title[$i]) && (trim($title[$i])=="PRENOM ET NOM" || $title[$i]=="PRENOM ET NOM ")) 
                                     $prenom_et_nom=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="priorités") 
                                     $priorites=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="solde") 
                                     $solde=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="téléphone") 
                                     $telephone=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="signataire sur le compte") 
                                     $signataire_sur_le_compte=$array[$i];
                                
                            }
                             $sql="INSERT INTO public.client_infos_reactivation(id_client,numero_compte, prenom_et_nom, priorites, solde,telephone,signataire_sur_le_compte) VALUES(DEFAULT,'".$numero_compte."','".$prenom_et_nom."','".$priorites."', '".$solde."','".$telephone."','".$signataire_sur_le_compte."')";
                             //var_dump($sql);
                             $PHONE=$this->cleanPhone($telephone);
                             $sql_numerol="INSERT INTO public.numero(id,libelle,status,nom_campagne,dnis_campagne,id_campagne)VALUES(DEFAULT,'".$PHONE."','".$statInsert."','ECOBANK_REACTIVATION','2700','9')"; 
                             $stmt = $connexion->prepare($sql_numerol);
                             $stmt->execute();
                            $trouve=true;
                            if($numero_compte=='' && $prenom_et_nom=='' && $priorites=='' && $solde=='' && $telephone=='' && $signataire_sur_le_compte=='')
                            $trouve=false;
                            if($trouve)
                            { 
                             $total++;  
                             $stmt = $connexion->prepare($sql);
                             $stmt->execute();
                             $num_rows_affected1 = $connexion->lastInsertId();
                             $num_rows_affected=$num_rows_affected.';'.$num_rows_affected1;
                            }
                        }
                   
                }
                $sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'REACTIVATION','".$matricule."','".$total."')";
                $stmt=$connexion->prepare($sql);
                $stmt->execute();       
             fclose($f);
            // exit;
        }
        //cafrique
    if ($type=='Cafrique') {
            $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;
               $num_rows_affected='';$total=0;
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                   
                //  var_dump($sql);
                    if ($firstLigne==true)
                        { 
                         $title=$array;
                         $firstLigne=false;
                         //var_dump('<br>*****<br>',$array,'<br>*****<br>');
                        }else{
                                 $annonceur=$email=$phone=$sites=$phone=$nombre=$categories='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                     //var_dump('<br>*****<br>',$array,'<br>');
                                 if (isset($title[$i]) && trim($title[$i])=="Annonceur") 
                                     $annonceur=$array[$i];
                                 if (isset($title[$i]) && (trim($title[$i])=="Email" )) 
                                     $email=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Phone") 
                                     $phone=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Sites") 
                                     $sites=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Nombre d'annonces") 
                                     $nombre=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Categories") 
                                     $categories=$array[$i];
                                
                            }
                            //$PHONE=$this->cleanPhoneCafrikSN($phone);
                            $PHONE='00'.$phone;
                            $categories=str_replace("'", "''",$categories);
                            $annonceur=str_replace("'", "''",$annonceur);
                             $sql="INSERT INTO public.client_infos_cafrique(client_id,client_num_tel,client_annonceur,client_email,client_site,client_nbr_annonce,client_categorie) VALUES(DEFAULT,'".$PHONE."','".$annonceur."','".$email."', '".$sites."','".$nombre."','".$categories."')";
                             //var_dump($sql);
                             
                             $sql_numerol="INSERT INTO public.numero(id,libelle,status,nom_campagne,dnis_campagne,id_campagne)VALUES(DEFAULT,'".$PHONE."','".$statInsert."','COIN_AFRIQUE','2729','8')"; 
                             $stmt = $connexion->prepare($sql_numerol);
                             $stmt->execute();
                            $trouve=true;
                            if($annonceur=='' && $email=='' && $phone=='' && $sites=='' && $nombre=='' && $categories=='' && strlen($annonceur)>50 && strlen($email)>50 && strlen($PHONE)>50 && strlen($categories)>50 && $annonceur=='"[email&#160;protected]"')
                            $trouve=false;
                            if($trouve)
                            { 
                             $total++; 
                             try {
                                $stmt = $connexion->prepare($sql);
                                $stmt->execute();
                              } catch (Exception $e) {
                                
                              } 
                             
                              $num_rows_affected1 = $connexion->lastInsertId();
                              $num_rows_affected  = $num_rows_affected.';'.$num_rows_affected1;
                            }
                        }
                   
                }
                //$sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'REACTIVATION','".$matricule."','".$total."')";
                //$stmt=$connexion->prepare($sql);
                //$stmt->execute();       
             fclose($f);
            // exit;
        }
        //cafrique CI
    if ($type=='Cafrique1') {
            $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;
               $num_rows_affected='';$total=0;
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                   
                //  var_dump($sql);
                    if ($firstLigne==true)
                        { 
                         $title=$array;
                         $firstLigne=false;
                         //var_dump('<br>*****<br>',$array,'<br>*****<br>');
                        }else{
                                 $annonceur=$email=$phone=$sites=$phone=$nombre=$categories='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                     //var_dump('<br>*****<br>',$array,'<br>');
                                 if (isset($title[$i]) && trim($title[$i])=="Annonceur") 
                                     $annonceur=$array[$i];
                                 if (isset($title[$i]) && (trim($title[$i])=="Email" )) 
                                     $email=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Phone") 
                                     $phone=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Sites") 
                                     $sites=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Nombre d'annonces") 
                                     $nombre=$array[$i];
                                 if (isset($title[$i]) && trim($title[$i])=="Categories") 
                                     $categories=$array[$i];
                                
                            }
                            $PHONE=$this->cleanPhoneCafrikCI($phone);
                            $categories=str_replace("'", "''",$categories);
                            $annonceur=str_replace("'", "''",$annonceur);
                             $sql="INSERT INTO public.client_infos_cafrique_ci(client_id,client_num_tel,client_annonceur,client_email,client_site,client_nbr_annonce,client_categorie) VALUES(DEFAULT,'".$PHONE."','".$annonceur."','".$email."', '".$sites."','".$nombre."','".$categories."')";
                             //var_dump($sql);
                             
                             $sql_numerol="INSERT INTO public.numero(id,libelle,status,nom_campagne,dnis_campagne,id_campagne)VALUES(DEFAULT,'".$PHONE."','".$statInsert."','COIN_AFRIQUE_CI','2734','12')"; 
                             $stmt = $connexion->prepare($sql_numerol);
                             $stmt->execute();
                            $trouve=true;
                            if($annonceur=='' && $email=='' && $phone=='' && $sites=='' && $nombre=='' && $categories=='' && strlen($annonceur)>50 && strlen($email)>50 && strlen($PHONE)>50 && strlen($categories)>50 && $annonceur=='"[email&#160;protected]"')
                            $trouve=false;
                            if($trouve)
                            { 
                             $total++; 
                             try {
                                $stmt = $connexion->prepare($sql);
                                $stmt->execute();
                              } catch (Exception $e) {
                                
                              } 
                             
                              $num_rows_affected1 = $connexion->lastInsertId();
                              $num_rows_affected  = $num_rows_affected.';'.$num_rows_affected1;
                            }
                        }
                   
                }
                //$sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'REACTIVATION','".$matricule."','".$total."')";
                //$stmt=$connexion->prepare($sql);
                //$stmt->execute();       
             fclose($f);
            // exit;
        }
       //b2b              
    if ($type=='B2B') {
            $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;
               $num_rows_affected='';$total=0;
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                   
                //  var_dump($sql);
                  //  if ($firstLigne==true)
                    //    { 
                      //   $title=$array;
                       //  $firstLigne=false;
                         //var_dump('<br>*****<br>',$array,'<br>*****<br>');
                        //}else{
                                 $entreprise=$adr=$vid=$ville=$tel=$cat=$site='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                     //var_dump('<br>*****<br>',$array,'<br>');
                                 if ($i==0) 
                                     $entreprise=$array[$i];
                                 if ($i==1) 
                                     $adr=$array[$i];
                                 if ($i==2) 
                                     $vid=$array[$i];
                                 if ($i==3) 
                                     $ville=$array[$i];
                                 if ($i==4) 
                                     $tel=$array[$i];
                                 if ($i==5) 
                                     $cat=$array[$i];
                                 if ($i==6) 
                                     $site=$array[$i];  
                                
                            }
                            $PHONE=$this->cleanPhoneMobileStore($tel);
                            $adr=str_replace("'", "''",$adr);
                            $cat=str_replace("'", "''",$cat);
                            $ville=str_replace("'", "''",$ville);
                            $entreprise=str_replace("'", "''",$entreprise);
                            $sql="INSERT INTO public.client_infos_b2b_op(client_id,client_num_tel,client_entreprise,client_site,client_categorie,client_adresse,client_ville_id,client_ville) VALUES(DEFAULT,'".$PHONE."','".$entreprise."','".$site."', '".$cat."','".$adr."','".$vid."','".$ville."')";
                            //var_dump($sql);
                             
                             $sql_numerol="INSERT INTO public.numero(id,libelle,status,nom_campagne,dnis_campagne,id_campagne)VALUES(DEFAULT,'".$PHONE."','".$statInsert."','MOBILESTORE_B2B','2730','14')"; 
                             $stmt = $connexion->prepare($sql_numerol);
                             $stmt->execute();
                            $trouve=true;
                            if($entreprise=='' && $adr=='' && $vid=='' && $ville=='' && $tel=='' && $cat=='' && $site=='' )
                            $trouve=false;
                            if($trouve)
                            { 
                             $total++; 
                             try {
                                $stmt = $connexion->prepare($sql);
                                $stmt->execute();
                              } catch (Exception $e) {
                                
                              } 
                             
                             $num_rows_affected1 = $connexion->lastInsertId();
                             $num_rows_affected=$num_rows_affected.';'.$num_rows_affected1;
                            }
                        }
                   
                //}
                //$sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'REACTIVATION','".$matricule."','".$total."')";
                //$stmt=$connexion->prepare($sql);
                //$stmt->execute();       
             fclose($f);
            // exit;
        }
       //end b2b 
      //b2co
       if ($type=='B2CO') {
            $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;
               $num_rows_affected='';$total=0;
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                   
                //  var_dump($sql);
                    // if ($firstLigne==true)
                    //     { 
                    //      $title=$array;
                    //      $firstLigne=false;
                    //      //var_dump('<br>*****<br>',$array,'<br>*****<br>');
                    //     }else{
                                 $non=$prenom=$adr=$vid=$vil=$tel=$com='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                     //var_dump('<br>*****<br>',$array,'<br>');
                                 if ($i==0) 
                                     $non=$array[$i];
                                 if ($i==1)      
                                     $prenom=$array[$i];
                                 if ($i==2)      
                                     $adr=$array[$i];
                                 if ($i==3)      
                                     $vid=$array[$i];
                                 if ($i==4)      
                                     $vil=$array[$i];
                                 if ($i==5)      
                                     $tel=$array[$i];
                                 if ($i==6)      
                                     $com=$array[$i];  
                                
                            }
                           
                            $adr=str_replace("'", "''",$adr);
                            $com=str_replace("'", "''",$com);
                            $vil=str_replace("'", "''",$vil);
                            $PHONE=$this->cleanPhoneMobileStore($tel);
                             $sql="INSERT INTO public.client_infos_b2c_op(client_id,client_num_tel,client_nom,client_prenom,client_adresse,client_ville_id,client_ville,client_note) VALUES(DEFAULT,'".$PHONE."','".$non."','".$prenom."', '".$adr."','".$vid."','".$vil."','".$com."')";
                             //var_dump($sql);
                             
                             $sql_numerol="INSERT INTO public.numero(id,libelle,status,nom_campagne,dnis_campagne,id_campagne)VALUES(DEFAULT,'".$PHONE."','".$statInsert."','MOBILESTORE_B2C','2731','15')"; 
                             $stmt = $connexion->prepare($sql_numerol);
                             $stmt->execute();
                            $trouve=true;
                            if($non=='' && $prenom=='' && $adr=='' && $vid=='' && $vil=='' && $tel=='' && $com=='')
                            $trouve=false;
                            if($trouve)
                            { 
                             $total++; 
                             try {
                                $stmt = $connexion->prepare($sql);
                                $stmt->execute();
                              } catch (Exception $e) {
                                
                              } 
                             
                             $num_rows_affected1 = $connexion->lastInsertId();
                             $num_rows_affected=$num_rows_affected.';'.$num_rows_affected1;
                            }
                        }
                   
               // }
                //$sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'REACTIVATION','".$matricule."','".$total."')";
                //$stmt=$connexion->prepare($sql);
                //$stmt->execute();       
             fclose($f);
            // exit;
        }  
      //end b2co  
      //b2cf
        if ($type=='B2CF') {
            $f = fopen($filePath, "r") or exit("Unable to open file!");
               $firstLigne=true;
               $num_rows_affected='';$total=0;
               //var_dump($filePath);
                while (!feof($f)) {
                    $array = explode(';', fgets($f));
                   //var_dump( $array,$f);
                //  var_dump($sql);
                    // if ($firstLigne==true)
                    //     { 
                    //      $title=$array;
                    //      $firstLigne=false;
                    //      //var_dump('<br>*****<br>',$array,'<br>*****<br>');
                    //     }else{
                                 $non=$prenom=$adr=$vid=$vil=$tel=$com='';
                            for ($i=0; $i <count($array) ; $i++) { 
                                     //var_dump('<br>*****<br>',$array,'<br>');
                                 if ($i==0) 
                                     $non=$array[$i];
                                 if ($i==1)      
                                     $prenom=$array[$i];
                                 if ($i==2)      
                                     $adr=$array[$i];
                                 if ($i==3)      
                                     $vid=$array[$i];
                                 if ($i==4)      
                                     $vil=$array[$i];
                                 if ($i==5)      
                                     $tel=$array[$i];
                                 if ($i==6)      
                                     $com=$array[$i];  
                                
                            }
                           
                            $adr=str_replace("'", "''",$adr);
                            $com=str_replace("'", "''",$com);
                            $vil=str_replace("'", "''",$vil);
                            $non=str_replace("'", "''",$non);
                            $prenom=str_replace("'", "''",$prenom);
                            $PHONE=$this->cleanPhoneMobileStore($tel);
                             $sql="INSERT INTO public.client_infos_b2c_for(client_id,client_num_tel,client_nom,client_prenom,client_adresse,client_ville_id,client_ville,client_note) VALUES(DEFAULT,'".$PHONE."','".$non."','".$prenom."', '".$adr."','".$vid."','".$vil."','".$com."')";
                             //var_dump($sql);exit;
                             
                             $sql_numerol="INSERT INTO public.numero(id,libelle,status,nom_campagne,dnis_campagne,id_campagne)VALUES(DEFAULT,'".$PHONE."','".$statInsert."','MOBILESTORE_B2CFOR','2732','16')"; 
                             $stmt = $connexion->prepare($sql_numerol);
                             $stmt->execute();
                            $trouve=true;
                            if($non=='' && $prenom=='' && $adr=='' && $vid=='' && $vil=='' && $tel=='' && $com=='')
                            $trouve=false;
                            if($trouve)
                            { 
                             $total++; 
                             try {
                                $stmt = $connexion->prepare($sql);
                                $stmt->execute();
                              } catch (Exception $e) {
                                
                              } 
                             
                             $num_rows_affected1 = $connexion->lastInsertId();
                             $num_rows_affected=$num_rows_affected.';'.$num_rows_affected1;
                            }
                        }
                   
               // }
                //$sql="INSERT INTO public.importation(id,ids, created_at, type_importation,matricule_created,total) VALUES(DEFAULT,'".$num_rows_affected."','".date("Y-m-d H:i:s")."', 'REACTIVATION','".$matricule."','".$total."')";
                //$stmt=$connexion->prepare($sql);
                //$stmt->execute();       
             fclose($f);
             //exit;
        } 
      //end b2cf 

        //end cafrique
        //$message = $request->files->get('message');
       // var_dump($file);exit;
        

        // $f = fopen($filePath, "r") or exit("Unable to open file!");
        // while (!feof($f)) {
        //     $array = explode(';', fgets($f));
        //     //var_dump($array);
        //     if (count($array) >= 6 && $array[0]!='' && $array[1]!='' && $array[2]!='' && $array[3]!='' && $array[5]!='') {
        //       $sql="INSERT INTO public.groupe_contact(id, nom, prenom, mail, tel, adresse, etat, groupe_name)VALUES (DEFAULT,'".$array[0]."','".$array[1]."', '".$array[2]."','".$array[3]."','".$array[4]."', '1','".trim($array[5])."')";       
        //       $stmt = $connexion->prepare($sql);
        //       $num_rows_affected = $stmt->execute();
               
        //     }


        // }
       // exit();

       // fclose($f);
          $request->getSession()->getFlashBag()->set('success', 'Importation effectue avec Succès!');
             //return new JsonResponse(array('return'=>'true'));
          return $this->redirectToRoute('chaka_realtime_homepage',array('return'=>'true'));

    }
    public function updateAcwAction($acw, $numPoste, $uuid)
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();
        $sql = "UPDATE appels SET appels_acw = '$acw' WHERE appels_uuid= '$uuid' AND appels_num_poste='$numPoste'";
        $stmt = $connexion->prepare($sql);
        $num_rows_affected = $stmt->execute();
        $response = new Response(
            json_encode(
                array(
                    'reponse' => "OK",
                    'numRows' => $num_rows_affected,
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    public function savePauseAgentAction($pauseId)
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $userPrenom = $user->getPrenom();
        $userNom = $user->getNom();
        $datePause = date('Y-m-d H:i:s');

        $sql = "INSERT INTO pause_agent (
                pa_type_pause_id,
                pa_utilisateur_id,
                pa_utilisateur_matricule,
                pa_utilisateur_prenom,
                pa_utilisateur_nom,
                pa_date_debut)
                VALUES(
                $pauseId,
                $userId,
                '$userMatricule',
                '$userPrenom',
                '$userNom',
                '$datePause'
                )";
        $stmt = $connexion->prepare($sql);
        $num_rows_affected = $stmt->execute();

        if ($num_rows_affected < 1):
            $retour = "KO";
        else:
            $retour = "OK";
        endif;

        $response = new Response(
            json_encode(
                array(
                    'reponse' => $retour,
                    'num_rows_affected' => $num_rows_affected,
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    public function saveReprisePauseAgentAction()
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $user = $this->getUser();
        $userId = $user->getId();
        $userMatricule = $user->getMatricule();
        $datePause = date('Y-m-d H:i:s');

        $sql = "UPDATE pause_agent
                SET pa_date_fin = '$datePause'
                WHERE pa_utilisateur_id = $userId
                AND pa_date_fin is null
                ";
        $stmt = $connexion->prepare($sql);
        $num_rows_affected = $stmt->execute();

        if ($num_rows_affected < 1):
            $retour = "KO";
        else:
            $retour = "OK";
        endif;

        $response = new Response(
            json_encode(
                array(
                    'reponse' => $retour,
                    'num_rows_affected' => $num_rows_affected,
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    public function getAgentAction($matricule)
    {
        $em = $this->getDoctrine()->getManager();

        $sql = "SELECT prenom, nom FROM utilisateurs WHERE matricule = '$matricule' LIMIT 1";
        $stmt = $em->getConnection()->prepare($sql);
        $stmt->execute();
        $agent = $stmt->fetchAll();

        $prenom = $agent[0]['prenom'];
        $nom = $agent[0]['nom'];

        return new Response("$prenom $nom");
    }

    public function updateAgentNbreAppelsAction($matricule, $isAppelTraite)
    {
        $appelTraite = 0;
        $appelsNonTraite = 0;

        if ($isAppelTraite == 1):
            $appelTraite = 1;
        else:
            $appelsNonTraite = 1;
        endif;

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $userId = $user->getId();

        $sql = "UPDATE feuille_presence SET fp_nb_appels_traites = fp_nb_appels_traites + $appelTraite,
                fp_nb_appels_non_traites = fp_nb_appels_non_traites + $appelsNonTraite
                WHERE fp_utilisateur_id = $userId AND fp_date_pointage::date = CURRENT_DATE";
        $stmt = $em->getConnection()->prepare($sql);
        $stmt->execute();

        $session = $this->get('session');
        $session->set('nbAppelsTraites', $session->get('nbAppelsTraites') + $appelTraite);
        $session->set('nbAppelsNonTraites', $session->get('nbAppelsNonTraites') + $appelsNonTraite);

        $response = new Response(
            json_encode(
                array(
                    'nbAppelsTraites' => $session->get('nbAppelsTraites'),
                    'nbAppelsNonTraites' => $session->get('nbAppelsNonTraites'),
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');

        return $response;
    }

    public function logoutAction($matricule)
    {
        $session = $this->get('session');
        $session->set('isFirstConnection', null);

        $em = $this->getDoctrine()->getManager();

        $sql = "UPDATE feuille_presence SET fp_date_fin_session = CURRENT_TIMESTAMP 
                WHERE fp_utilisateur_matricule = '$matricule' 
                AND fp_date_fin_session IS NULL";
        $stmt = $em->getConnection()->prepare($sql);
        $stmt->execute();

        return $this->redirect( $this->generateUrl('fos_user_security_logout') );
    }
    public function cleanPhone($value)
    {
     $val1=$value;
      $val=explode(' ',$value);

      foreach ($val as $key => $value) {
       if (is_numeric($value)) 
        $val1=$value;   
      }
      
    
      if (substr($val1,0,2)=="237") {
          $val1=substr($val1,3);
      }
      if (strlen($val1)==12) {
       return '00'.$val1;
      }else
      {
        
       return '00237'.$val1;
      }
    }
        public function cleanPhoneCafrikSN($value)
    {
     $val1=$value;
      $val=explode(' ',$value);

      foreach ($val as $key => $value) {
       if (is_numeric($value)) 
        $val1=$value;   
      }
      
    
      if (substr($val1,0,2)=="221") {
          $val1=substr($val1,3);
      }
      if (strlen($val1)==12) {
       return '00'.$val1;
      }else
      {
        
       return '00221'.$val1;
      }
    }
            public function cleanPhoneCafrikCI($value)
    {
     $val1=$value;
      $val=explode(' ',$value);

      foreach ($val as $key => $value) {
       if (is_numeric($value)) 
        $val1=$value;   
      }
      
    
      //if (substr($val1,0,2)=="225") {
        //  $val1=substr($val1,3);
      //}
      //if (strlen($val1)==12) {
       return '00'.$val1;
      //}else
      //{
        
      // return '00225'.$val1;
     // }
    }
     public function cleanPhoneMobileStore($value)
    {
     $val1=$value;

     if (substr( $val1, 0, 1)=="0") {
       $val1=substr($val1, 1, 101);
     }
       $val1=explode(' ', $val1);
       $val1= implode('',$val1);
       $val1=trim($val1);
       
     return '33'.$val1;
      
      
    }   
}
