<?php

namespace Chaka\TdbOutbandBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;

class FicheController extends Controller
{

    public function indexAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        //RECUPERATION DES QUALIFICATIONS
        $sql = "SELECT q.idqualif, q.libelle FROM qualifications q 
                ORDER BY libelle";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $qualifications = $stmt->fetchAll();
        //RECUPERATION DES TYPES QUALIFICATIONS
        $sqlTypeQualif = "SELECT * FROM type_qualification ORDER BY libelle";
        $stmtTypeQualif = $connexion->prepare($sqlTypeQualif);
        $stmtTypeQualif->execute();
        $TypesQualif = $stmtTypeQualif->fetchAll();
        $jsontypesQualification= json_encode($TypesQualif);
        //RECUPERATION DES CODIFICATIONS
        $sqlC = "SELECT * FROM codification_sortants ORDER BY codification_libelle";
        $stmtC = $connexion->prepare($sqlC);
        $stmtC->execute();
        $codifications = $stmtC->fetchAll();
         //RECUPERATION DES RESULTATS
        $sqlResult = "SELECT * FROM result ORDER BY resultat_libelle";
        $stmtResult = $connexion->prepare($sqlResult);
        $stmtResult->execute();
        $resultats = $stmtResult->fetchAll();
         //RECUPERATION DES STATUTS
        $sqlStatut = "SELECT * FROM statut ORDER BY statut_libelle";
        $stmtStatut = $connexion->prepare($sqlStatut);
        $stmtStatut->execute();
        $statuts = $stmtStatut->fetchAll();
         //RECUPERATION DES TYPES D'APPEL
        $sqlTypeAppel = "SELECT * FROM type_appel ORDER BY type_appel_libelle";
        $stmtTypeAppel = $connexion->prepare($sqlTypeAppel);
        $stmtTypeAppel->execute();
        $TypesAppel = $stmtTypeAppel->fetchAll();
        //RECUPERATION DES COMMUNICATIONS
        $sqlComm = "SELECT * FROM communication ORDER BY communication_libelle";
        $stmtComm = $connexion->prepare($sqlComm);
        $stmtComm->execute();
        $Communications = $stmtComm->fetchAll();
        $jsonCommunications= json_encode($Communications);
         //RECUPERATION DES CLIMATS
        $sqlClimat = "SELECT * FROM climat ORDER BY climat_libelle";
        $stmtClimat = $connexion->prepare($sqlClimat);
        $stmtClimat ->execute();
        $Climats = $stmtClimat ->fetchAll();
         //RECUPERATION CATEGORIE
        $sql ="SELECT * FROM public.categorie_probleme where positionnement='sortant' ORDER BY libelle_categorie ASC";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $Categories = $stmt->fetchAll();
        $jsonCategories = json_encode($Categories);
        //RECUPERATION ITEM PROBLEME
         $sqlItem ="SELECT * FROM public.item_probleme    ORDER BY libelle_item DESC ";
        $stmtItem = $connexion->prepare($sqlItem);
        $stmtItem->execute();
        $Items = $stmtItem->fetchAll();
        $jsonItemProbleme = json_encode($Items);

        return $this->render('ChakaTdbOutbandBundle:Fiche:index.html.twig',
            array("qualifications" => $qualifications,"codifications"=>$codifications,
                "resultats"=>$resultats,"statuts"=>$statuts,"typesappel"=>$TypesAppel,
                "communications"=>$jsonCommunications,
                "climats"=>$Climats,"typesQualification"=>$jsontypesQualification,
                "Categories"=>$Categories,"itemsProbleme"=>$jsonItemProbleme
            )
        );
    }

    public function getClientInfosAction($numClient = null, $campagne)
    {
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();
        $sql  = "SELECT * FROM clients_infos JOIN pays ON client_pays::integer = idpays"
                . " WHERE client_num_tel = '$numClient'";
        $sqlP = "SELECT * FROM problemes_poses_canal WHERE pbpose_num_tel = '$numClient'";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $client = $stmt->fetchAll();
        $stmt = $connexion->prepare($sqlP);
        $stmt->execute();
        $problemes = $stmt->fetchAll();
        $response = new Response(
            json_encode(
                array(
                    'clientInfos' => $client,
                    'problemes'   => $problemes,
                 )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    public function saveClientInfosAction(Request $request)
    {
        $isNewClient = str_replace("'", "''", $request->request->get("isNewClient"));
        $numClient = $request->request->get("nume-client");
        $prenom = str_replace("'", "''", $request->request->get("prenoms"));
        $nom = str_replace("'", "''", $request->request->get("nom"));
        $entreprise = str_replace("'", "''", $request->request->get("entreprise"));
        $profession = str_replace("'", "''", $request->request->get("profession"));
        $autreNum = str_replace("'", "''", $request->request->get("autre-num"));
        $accordRdv = str_replace("'", "''", $request->request->get("reponserdv"));
        $motifRefus = str_replace("'", "''", $request->request->get("motif_refus"));
        $commune = str_replace("'", "''", $request->request->get("commune"));
        $localisation = str_replace("'", "''", $request->request->get("localisation"));
        $commentaire = str_replace("'", "''", $request->request->get("commentaire"));
        $nbreSouscripteurs = str_replace("'", "''", $request->request->get("nbre-souscripteurs"));
        $qualification = str_replace("'", "''", $request->request->get("qualification"));
        $dateRdv = str_replace("'", "''", $request->request->get("daterdv")) . " " . str_replace("'", "''", $request->request->get("heurerdv"));
        $dateQualif = date('Y-m-d H:i:s');
        if ($dateRdv == "" || $dateRdv == " " || $dateRdv == null):
            $dateRdv = date('Y-m-d H:i:s');
        endif;
        $dateRappel = str_replace("'", "''", $request->request->get("date_rappel")) . " " . str_replace("'", "''", $request->request->get("heure_rappel"));
        $estArappeler = 1;
        if ($dateRappel == "" || $dateRappel == " " || $dateRappel == null):
            $dateRappel = date('Y-m-d H:i:s');
            $estArappeler = 0;
        endif;
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();

        $sql = "UPDATE client_infos_prv
                SET prenoms = '$prenom',
                nom = '$nom',
                mobile2 = '$autreNum',
                entreprise = '$entreprise',
                activite = '$profession',
                accord_pr_echanger = '$accordRdv',
                motif_freins = '$motifRefus',
                qualif = '$qualification',
                date_rdv = '$dateRdv',
                date_rappel = '$dateRappel',
                est_a_rappeler = '$estArappeler',
                date_qualif = '$dateQualif',
                communes = '$commune',
                localisation = '$localisation',
                commentaires = '$commentaire',
                nmbr_souscripteur = '$nbreSouscripteurs', 
                last_call = date 
                WHERE tel = '$numClient'";

        $stmt = $connexion->prepare($sql);
        //$stmt->execute();

        $num_rows_affected = $stmt->execute();
        if ($num_rows_affected < 1):
            $retour = "KO";
        else:
            $retour = "OK";
        endif;

        $response = new Response(
            json_encode(
                array(
                    'reponse' => $retour,
                    'isNew' => $isNewClient,
                    'query' => $sql,
                    'num_rows_affected' => $num_rows_affected,
                )
            )
        );
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }


    public function saveCodificationsAction(Request $request)
    {
        $user = $this->getUser();
        $userMatricule = $user->getMatricule();

        $numClient = $request->request->get("nume-client");
        $campagne = $request->request->get("campagne");
        $date_appel = $request->request->get("date_appel");
        // $acw = $request->request->get("nbre-acw");
        $commentaire = str_replace("'", "''", $request->request->get("commentaires"));
        //$compteAuto = str_replace("'", "''", $request->request->get("compteAuto"));
        $qualification = str_replace("'", "''", $request->request->get("qualification"));
        $typequalification = str_replace("'", "''", $request->request->get("typequalification"));
        $codification = str_replace("'", "''", $request->request->get("codification"));
        $typecodification = str_replace("'", "''", $request->request->get("typecodification"));
        $date_rappel = str_replace("'", "''", $request->request->get("date_rappel"));
        $heure_rappel = str_replace("'", "''", $request->request->get("heure_rappel"));
        $pbpose_climat =$request->request->get("climat");
        $resultat = str_replace("'", "''", $request->request->get("resultat"));
         if($resultat)
        {
            $tab_resultat = explode ("-", $resultat); 
            if($tab_resultat)
            $resultat = $tab_resultat[0];
        }
        $statut = str_replace("'", "''", $request->request->get("statut"));
         if($statut)
        {
            $tab_statut = explode ("-", $statut); 
            if($tab_statut)
            $statut = $tab_statut[0];
        }
        $code_agent  = str_replace("'", "''", $request->request->get("code-agent"));
        $canal="sortant";
         $categorie                  = $request->request->get("categorie");
        if($categorie)
        {
            $tabcateg = explode ("-", $categorie); 
            if($tabcateg)
            $categorie = $tabcateg[0];
        }
        $problemes                  = $request->request->get("problemes");   
         if($problemes)
        {
            $tab_probleme= explode ("-", $problemes); 
            if($tab_probleme)
            $problemes = $tab_probleme[0];
        }
         $pbpose_type_appel = str_replace("'", "''", $request->request->get("type-appel"));
         if($pbpose_type_appel)
        {
            $tab_typeappel = explode ("-", $pbpose_type_appel); 
            if($tab_typeappel)
            $pbpose_type_appel = $tab_typeappel[0];
        }
         $pbpose_communication = str_replace("'", "''", $request->request->get("communication"));
         
        // $dateRdv = str_replace("'", "''", $request->request->get("daterdv")) . " " . str_replace("'", "''", $request->request->get("heurerdv"));
        // $dateQualif = date('Y-m-d H:i:s');
        $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();
        if($numClient && $numClient!="")
        {
         $sql="INSERT INTO  problemes_poses_canal
         (pbpose_codification_sortants, pbpose_type_codification_sortants,
          pbpose_qualification,pbpose_type_qualification, pbpose_canal,
          pbpose_dnis_campagne,
          pbpose_num_tel,
          pbpose_commentaires,
          pbpose_matricule_agent,
          pbpose_date_rappel,
          pbpose_heure_rappel,
          pbpose_resultat,
          pbpose_statut_canal,
          pbpose_code_agent,
          pbpose_categorie,
          pbpose_probleme,
          pbpose_type_appel,
          pbpose_communication,
          pbpose_climat)
          VALUES('$codification','$typecodification','$qualification','$typequalification','$canal' ,'$campagne',"
                 . "'$numClient','$commentaire','$userMatricule','$date_rappel','$heure_rappel','$resultat','$statut','$code_agent',"
                 . "'$categorie','$problemes','$pbpose_type_appel','$pbpose_communication','$pbpose_climat')";  
        $stmt = $connexion->prepare($sql);


        $num_rows_affected = $stmt->execute();
        if($num_rows_affected < 1):
            $retour = "KO";
        else:
            $retour = "OK";
        endif;

        $response = new Response(
            json_encode(
                array(
                    'reponse' => $retour,
                    'query'=> $sql,
                    'num_rows_affected' => $num_rows_affected,
                )
            )
        );
        }
        else
        {
          $response = new Response(
            json_encode(
                array(
                    'reponse' => 'KO',
                    'num_client' => 'KO',
                )
            )
        );  
        }
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }
   public function typeQualificationAction($idqualification)
   {
       $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();
       $sql ="SELECT * FROM public.type_qualification where qualification_id=$idqualification and status='1' ORDER BY type_qualification_id DESC";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $typesQualifications = $stmt->fetchAll();
        $jsonTypesQualification = json_encode($typesQualifications);
        return new Response($jsonTypesQualification);
   }
    public function typeCodificationAction($idcodification)
   {
       $em = $this->getDoctrine()->getManager();
        $connexion = $em->getConnection();
       $sql ="SELECT * FROM public.type_codification_sortants where type_id=$idcodification  ORDER BY sous_type_id DESC";
        $stmt = $connexion->prepare($sql);
        $stmt->execute();
        $typesCodification = $stmt->fetchAll();
        $jsontypesCodification = json_encode($typesCodification);
        return new Response($jsontypesCodification);
   }
}
